<?php
/*--------------------------------------------------------------
   Text.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Data\Factory;

use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Text as TextData;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Text\Value as TextValue;

class Text
{
    /**
     * Return text data.
     */
    public function createTextData(TextValue $text): TextData
    {
        return TextData::create($text);
    }
    
    
    /**
     * Return value.
     */
    public function createValue(string $value): TextValue
    {
        return TextValue::create($value);
    }
}